﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace Spectral1.DATA_ACCESS
{
    public class c_patch_data_changed
    {
        public bool changed_since_last_save_to_module = false;
        private bool _patch_name_and_desc;
        private bool _misc;
        private bool[,] _adsr_section_envelope_config = new bool[DA_Spectral.max_adsr_sections, DA_Spectral.max_envelopes];
        private bool[] _adsr_section = new bool[DA_Spectral.max_adsr_sections];
        private bool[] _envelope_control_config = new bool[DA_Spectral.max_envelopes];
        private bool[] _lfo_envelope_config = new bool[DA_Spectral.max_lfos];


        #region "================= METHODS =============================="
        public void set_patch_name_and_desc(bool set)
        {
            if (set) { changed_since_last_save_to_module = true; }
            _patch_name_and_desc = set;
        }

        public bool get_patch_name_and_desc()
        {
            return _patch_name_and_desc;
        }

        public void set_misc(bool set)
        {
            if (set) { changed_since_last_save_to_module = true; }
            _misc = set;
        }

        public bool get_misc()
        {
            return _misc;
        }

        public void set_adsr_section_envelope_config(int section_id, int envelope_id, bool set)
        {
            if (set) { changed_since_last_save_to_module = true; }
            _adsr_section_envelope_config[section_id, envelope_id] = set;
        }

        public bool get_adsr_section_envelope_config(int section_id, int envelope_id)
        {
            return _adsr_section_envelope_config[section_id, envelope_id];
        }

        public void set_adsr_section(int section_id, bool set)
        {
            if (set) { changed_since_last_save_to_module = true; }
            _adsr_section[section_id] = set;
        }

        public bool get_adsr_section(int section_id)
        {
            return _adsr_section[section_id];
        }

        public void set_envelope_control_config(int envelope_id, bool set)
        {
            if (set) { changed_since_last_save_to_module = true; }
            _envelope_control_config[envelope_id] = set;
        }

        public bool get_envelope_control_config(int envelope_id)
        {
            return _envelope_control_config[envelope_id];
        }

        public void set_lfo_envelope_config(int lfo_id, bool set)
        {
            if (set) { changed_since_last_save_to_module = true; }
            _lfo_envelope_config[lfo_id] = set;
        }

        public bool get_lfo_envelope_config(int lfo_id)
        {
            return _lfo_envelope_config[lfo_id];
        }
        public c_patch_data_changed()
        {
            set_all(false);
        }

        public void set_all(bool b)
        {
            _misc = b;

            for (int s = 0; s < DA_Spectral.max_adsr_sections; s++)
            {
                for (int e = 0; e < DA_Spectral.max_envelopes; e++)
                {
                   set_adsr_section_envelope_config(s, e,b);
                }
            }

            for (int s = 0; s < DA_Spectral.max_adsr_sections; s++) { set_adsr_section(s,b); }

            for (int e = 0; e < DA_Spectral.max_envelopes; e++) { set_envelope_control_config(e,b); }

            for (int l = 0; l < DA_Spectral.max_lfos; l++) { set_lfo_envelope_config(l,b); }
        }

        #endregion


    }
}
